// MWLL Application.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "MechHeatTrack.h"

using namespace std;

int _tmain(int argc, _TCHAR* argv[])
{
	CMechHeatTrack mht(1, 10, CMechHeatTrack::SINGLE, 100);
	mht.ShowStatus();

	int ran_heat, ran_cooling, ran;
	srand(time(0));	// seed random number

	// make some random tests...
	for (int i = 0; i < 10; i++)
	{
		ran_heat = (rand() % 60);
		ran_cooling = (rand() % 40) + 1;
		ran = (rand() % 5) + 1;
		mht.AddHeat(ran_heat);
	
		// change environment on a 25% chance
		if(ran_cooling <= 10) {
			switch(ran) {
				case 1:
					mht.ChangeEnvironment(CMechHeatTrack::SPACE);
					break;
				case 2:
					mht.ChangeEnvironment(CMechHeatTrack::IN_WATER);
					break;
				case 3:
					mht.ChangeEnvironment(CMechHeatTrack::IN_HOT_AIR);
					break;
				case 4:
					mht.ChangeEnvironment(CMechHeatTrack::IN_COLD_AIR);
					break;
				case 5:
					mht.ChangeEnvironment(CMechHeatTrack::IN_TEMPARATE_AIR);
					break;
			}
		}
		// use coolant on a 60% chance
		if(ran <= 3)
			mht.UseCoolant(ran_cooling);
		// damage heatsinks on a 33 % chance
		if(ran_heat > 40)
			mht.UpdateHeatsinkDamage((float) (ran * 5) / 100);
		
		// regular trigger
		mht.UpdateCooling();
		// I don't call GetOverheatStatus() and GetCriticalTempStatus() here
		// 'cause the info is already in my testing output

		//Sleep(2000);
	}

	mht.ShowStatus();

	return 0;
}

