/*
MechWarrior Living Legends Programing Task

Please write a cpp file to go with this header file and submit both. Feel free to
make up numbers and formula as needed but try to make them reasonably reaslistic.
What we're looking for is basic skills plus creativity. If you can give a good feel
and functionality to the behaviors.

We are looking for the the following behaviors:
1. The main program will trigger the UpdateCooling() function n each timer tick to
	recalculate TotalHeat, RateOfHeatChange and update the flags for OverHeat
	and CriticalTemp and will also regularly call the GetOverheatStatus() and
	GetCriticalTempStatus() functions to check on the mech.
2. Assume the damage model will calculate damage as a percentage (0 to 1) of overall
	heat sink damage rather than per heatsink damage.
4. The coolant is measured in liters. Assume that the mech always starts with a full
	coolant tank.
*/

class CMechHeatTrack
{

public:
	//Double heat sinks dissapate exactly twice the heat of singles
	enum HeatSinkTypes
	{
		SINGLE,
		DOUBLE
	};

	//You should be able to figure out how environment effects heat disapation
	enum ThermalEnvironment
	{
		SPACE,
		IN_WATER,
		IN_HOT_AIR,
		IN_COLD_AIR,
		IN_TEMPARATE_AIR
	};

	CMechHeatTrack(
			float baseCoolRate, 
			int heatSinkCount, 
			HeatSinkTypes typeOfHeatSinks, 
			int coolantCapacity);
	~CMechHeatTrack() {};

	void UpdateCooling();
	void UpdateHeatsinkDamage(float);
	void ChangeEnvironment(ThermalEnvironment);
	void AddHeat(double);
	void UseCoolant(int);
	double GetRateOfHeatChange();
	double GetHeat();
	bool GetOverheatStatus();
	bool GetCriticalStatus();
	std::string GetEnvironmentName(ThermalEnvironment);	// for testing purposes
	void ShowStatus();		// for testing purposes

private:
	float baseCoolingFactor;
	int numberOfHeatSinks;
	HeatSinkTypes typeOfHeatSink;
	float heatsinkDamage;
	ThermalEnvironment environment;
	int coolantInTank;
	float rateOfHeatChange;
	double totalHeat;
	bool overHeat;
	bool criticalTemp;
	double additionalHeat;		// keeps additional heat till next tick
	double additionalCooling;	// keeps additional cooling till next tick
};